/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.common;

import com.ibm.hsc.client.PIVirtualSlotDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.ui.framework.IllegalUserDataException;
import java.util.SortedSet;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public abstract class PIVirtualSlotBaseDataBean {
    protected static final String VARIED_ON = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "VARIED_ON");
    protected static final String VARIED_OFF = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "VARIED_OFF");
    protected static final String UNKNOWN_STATE = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "UNKNOWN");
    protected static final String VIRTUAL_SLOT_ALREADY_USED = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "VIRTUAL_SLOT_ALREADY_USED");
    protected PIVirtualSlotDataBean m_baseCimBean;
    protected int m_slotNumber;
    protected int m_state;
    protected boolean m_isRequired;
    protected SortedSet m_slots;

    protected PIVirtualSlotBaseDataBean(PIVirtualSlotDataBean pIVirtualSlotDataBean, SortedSet sortedSet) {
        this.m_baseCimBean = pIVirtualSlotDataBean;
        this.m_slots = sortedSet;
        System.out.println("in PIVirtualSlotBaseDataBean()");
        this.m_isRequired = false;
    }

    public void setSlotNumber(double d) throws IllegalUserDataException {
        this.m_slotNumber = (int)Math.rint(d);
    }

    public double getSlotNumber() {
        return this.m_slotNumber;
    }

    public String getState() {
        switch (this.m_state) {
            case 0: {
                return VARIED_OFF;
            }
            case 1: {
                return VARIED_ON;
            }
        }
        return UNKNOWN_STATE;
    }

    public void setRequired(boolean bl) throws IllegalUserDataException {
        this.m_isRequired = bl;
    }

    public boolean isRequired() {
        return this.m_isRequired;
    }

    public void load() {
        UnsignedInt8 unsignedInt8;
        UnsignedInt16 unsignedInt16 = this.m_baseCimBean.getSlotNumber();
        if (unsignedInt16 != null) {
            this.m_slots.remove(unsignedInt16);
            this.m_slotNumber = unsignedInt16.intValue();
        } else {
            int n;
            int n2 = 1;
            unsignedInt8 = this.m_slots.tailSet(new UnsignedInt16(2)).iterator();
            while (unsignedInt8.hasNext() && (n = ((UnsignedInt16)unsignedInt8.next()).intValue()) <= n2 + 1) {
                n2 = n;
            }
            this.m_slotNumber = n2 + 1;
        }
        UnsignedInt8 unsignedInt82 = this.m_baseCimBean.getRuntimeState();
        if (unsignedInt82 != null) {
            this.m_state = unsignedInt82.intValue();
        }
        unsignedInt8 = this.m_baseCimBean.getRequired();
        System.out.println("isRequired = " + this.isRequired());
        if (unsignedInt8 != null) {
            if (unsignedInt8.shortValue() == 2) {
                System.out.println("in true");
                this.m_isRequired = true;
            } else {
                this.m_isRequired = false;
            }
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        if (this.m_slots.contains(new UnsignedInt16(this.m_slotNumber))) {
            throw new IllegalUserDataException(VIRTUAL_SLOT_ALREADY_USED);
        }
    }

    public void save() {
        this.m_baseCimBean.setSlotNumber(new UnsignedInt16(this.m_slotNumber));
        System.out.println("save() : " + this.m_isRequired);
        UnsignedInt8 unsignedInt8 = this.m_isRequired ? new UnsignedInt8(2) : new UnsignedInt8(1);
        this.m_baseCimBean.setRequired(unsignedInt8);
    }
}

